VERSION 5.00
Begin VB.Form frmU3800_Ext_SG_VCorrection 
   Caption         =   "U3800 External SG Vector Correction"
   ClientHeight    =   5235
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   5265
   BeginProperty Font 
      Name            =   "Arial"
      Size            =   9
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   LinkTopic       =   "Form1"
   ScaleHeight     =   5235
   ScaleWidth      =   5265
   StartUpPosition =   3  'Windows ̊l
   Begin VB.Frame FrmVCorr 
      Caption         =   "Vector Correction"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   3735
      Left            =   360
      TabIndex        =   5
      Top             =   1440
      Width           =   4695
      Begin VB.TextBox Txt_SG_Out_Level 
         Alignment       =   1  'E
         Height          =   330
         IMEMode         =   3  '̌Œ
         Left            =   3660
         TabIndex        =   20
         Top             =   2520
         Width           =   465
      End
      Begin VB.OptionButton Opt_VCorr_Type2 
         Caption         =   "InBand"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   240
         Left            =   2880
         TabIndex        =   18
         Top             =   390
         Width           =   1185
      End
      Begin VB.OptionButton Opt_VCorr_Type1 
         Caption         =   "Specific Span"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   150
         TabIndex        =   17
         Top             =   390
         Width           =   1785
      End
      Begin VB.CommandButton CmdVCorrStart 
         Caption         =   "Start"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   15.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   645
         Left            =   600
         TabIndex        =   7
         Top             =   2970
         Width           =   1335
      End
      Begin VB.CommandButton CmdVCorrAbort 
         Caption         =   "Abort"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   15.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   645
         Left            =   2850
         TabIndex        =   6
         Top             =   2970
         Width           =   1335
      End
      Begin VB.Label Label_Unit 
         Caption         =   "dBm"
         Height          =   225
         Left            =   4200
         TabIndex        =   21
         Top             =   2550
         Width           =   405
      End
      Begin VB.Label Label_SG_Output_Level 
         Caption         =   "SG Output Level"
         Height          =   285
         Left            =   2250
         TabIndex        =   19
         Top             =   2550
         Width           =   1395
      End
      Begin VB.Label Label_SG_Start_Freq 
         Caption         =   "SG Start Frequency "
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   180
         TabIndex        =   16
         Top             =   840
         Width           =   2025
      End
      Begin VB.Label Label_SG_Step_Freq 
         Caption         =   "SG Step Frequency "
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   180
         TabIndex        =   15
         Top             =   1260
         Width           =   2025
      End
      Begin VB.Label Label_SG_End_Freq 
         Caption         =   "SG End Frequency "
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   180
         TabIndex        =   14
         Top             =   1710
         Width           =   2025
      End
      Begin VB.Label Lbl_SG_Start_Freq 
         Alignment       =   1  'E
         BorderStyle     =   1  '
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   2250
         TabIndex        =   13
         Top             =   840
         Width           =   2300
      End
      Begin VB.Label Lbl_SG_Step_Freq 
         Alignment       =   1  'E
         BorderStyle     =   1  '
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   2250
         TabIndex        =   12
         Top             =   1260
         Width           =   2300
      End
      Begin VB.Label Lbl_SG_End_Freq 
         Alignment       =   1  'E
         BorderStyle     =   1  '
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   2250
         TabIndex        =   11
         Top             =   1680
         Width           =   2300
      End
      Begin VB.Label Label_SG_Current_Freq 
         Caption         =   "SG Current Frequency"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   180
         TabIndex        =   10
         Top             =   2160
         Width           =   2025
      End
      Begin VB.Label Lbl_SG_Current_Freq 
         Alignment       =   1  'E
         BorderStyle     =   1  '
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   2250
         TabIndex        =   9
         Top             =   2130
         Width           =   2300
      End
      Begin VB.Label Lbl_Count 
         Alignment       =   2  '
         Caption         =   "/"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   600
         TabIndex        =   8
         Top             =   2610
         Width           =   1365
      End
   End
   Begin VB.Frame FrmTCPIP 
      Caption         =   "TCP/IP"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1215
      Left            =   360
      TabIndex        =   0
      Top             =   90
      Width           =   4575
      Begin VB.TextBox Txt_SG_IP_Address 
         Alignment       =   1  'E
         BeginProperty DataFormat 
            Type            =   0
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1041
            SubFormatType   =   0
         EndProperty
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   360
         IMEMode         =   3  '̌Œ
         Left            =   2460
         TabIndex        =   1
         Top             =   390
         Width           =   1635
      End
      Begin VB.TextBox Txt_U38_IP_Address 
         Alignment       =   1  'E
         BeginProperty DataFormat 
            Type            =   0
            Format          =   "0"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1041
            SubFormatType   =   0
         EndProperty
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   360
         IMEMode         =   3  '̌Œ
         Left            =   2460
         TabIndex        =   2
         Top             =   750
         Width           =   1635
      End
      Begin VB.Label Lbl_U38_TCPIP_Address 
         Caption         =   "U3800 IP Address"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   720
         TabIndex        =   4
         Top             =   750
         Width           =   1995
      End
      Begin VB.Label Lbl_SG_TCPIP_Address 
         Caption         =   "    SG IP Address"
         BeginProperty Font 
            Name            =   "Arial"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   285
         Left            =   750
         TabIndex        =   3
         Top             =   420
         Width           =   1995
      End
   End
End
Attribute VB_Name = "frmU3800_Ext_SG_VCorrection"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'************************************
'* Setting acquisition of a Textbox *
'************************************
Private Sub GetSetting()

    str_U38_TcpipAddress = Txt_U38_IP_Address.Text
    Call WriteIniFile_U38_TCPIP_Adrs(Txt_U38_IP_Address.Text)
    
    str_SG_TcpipAddress = Txt_SG_IP_Address.Text
    Call WriteIniFile_SG_TCPIP_Adrs(Txt_SG_IP_Address.Text)

    U38_PortNo = CLng(ReadIniFile_U38_PortNo())
    SG_PortNo = CLng(ReadIniFile_SG_PortNo())

    SG_OutputLevel = CSng(Txt_SG_Out_Level.Text)
    Call WriteIniFile_SG_OUT_LVL(Txt_SG_Out_Level.Text)
    
    If Opt_VCorr_Type1.Value = True Then
        Call WriteIniFile_U38_VCorr_Type(Opt_VCorr_Type1.Caption)
    Else
        Call WriteIniFile_U38_VCorr_Type(Opt_VCorr_Type2.Caption)
    End If
    
End Sub

'***********************************************************
'* U3800 External SG Vector Correction Start               *
'*                                                         *
'* Etherbet I/F                                            *
'*   3Com 3C920 Integrated Fast Ethernet Controller        *
'*                                                         *
'* E8257D (Agilent) PSG Analog Signal Generator            *
'*   GPIB (SCIPI) Command                                  *
'*   SG_OUTPUT__CMD = "OUTP "                              *
'*   SG_OUT_ON__CMD = "ON"                                 *
'*   SG_OUT_OFF_CMD = "OFF"                                *
'*   SG_OUT_LVL_CMD = "SOUR:POW "                          *
'*   SG_OUT_LVL_UNT = "DBM"                                *
'*   SG_SET_FRQ_CMD = "SOUR:FREQ "                         *
'*   SG_SET_FRQ_UNT = "HZ"                                 *
'*                                                         *
'***********************************************************
Private Sub CmdVCorrStart_Click()
    Dim err As Long
    Dim i As Long
    Dim buf As String
    Dim VCorr_TtlCnt As Long
    Dim strVCorr_TtlCnt As String
    Dim CentFreq As Double
    Dim OfstFreq As Double
    Dim strFreq As String
    
    Lbl_SG_Start_Freq.Caption = ""
    Lbl_SG_Step_Freq.Caption = ""
    Lbl_SG_End_Freq.Caption = ""
    Lbl_SG_Current_Freq.Caption = ""
    Lbl_Count.Caption = "/"
    
    Call GetSetting        ' U3800 & SG Setting acquisition of a Textbox.
        
    '*** TCP/IP ****
    Call InitWinsock

    TcpipConnect = True
    If OpenSocket(U38_SockID, str_U38_TcpipAddress, U38_PortNo) < 0 Then
        err = MsgBox("Can't open the TCP/IP address(" & str_U38_TcpipAddress & ").", vbOKOnly)
        TcpipConnect = False
    Else
        err = GetSocket(U38_SockID, buf)
        err = PutSocket(U38_SockID, "REN")
    End If
    If OpenSocket(SG_SockID, str_SG_TcpipAddress, SG_PortNo) < 0 Then
        err = MsgBox("Can't open the TCP/IP address(" & str_SG_TcpipAddress & ").", vbOKOnly)
        TcpipConnect = False
    End If
    
    If TcpipConnect = False Then Exit Sub

    err = PutSocket(U38_SockID, "RFE")
    err = PutSocket(U38_SockID, "VCSIGSRC EXT")                     'SigSrc EXT

    err = QrySocket(U38_SockID, "CF?", buf)
    If err < 0 Then
        err = MsgBox("CF? query command error.", vbOKOnly)
        GoTo SocketClose
    End If
    
    CentFreq = CDbl(buf)
    strFreq = CStr(CentFreq)
    Lbl_SG_Current_Freq.Caption = strFreq
    err = PutSocket(SG_SockID, SG_SET_FRQ_CMD & strFreq & SG_SET_FRQ_UNT)
    Lbl_SG_Start_Freq.Caption = buf
    
    'Set SG output on
    err = PutSocket(SG_SockID, SG_OUT_ON__CMD)
    
    'Set SG output level
    err = PutSocket(SG_SockID, SG_OUT_LVL_CMD & CStr(SG_OutputLevel) & SG_OUT_LVL_UNT)
    Call Sleep(500)
    
    VCorrAbort = False
    
    If Me.Opt_VCorr_Type1.Value = True Then                         '*** Specific Span ***
        'Xmath 1.Power Ratio Phase Diff Execute ON/OFF
        err = QrySocket(U38_SockID, "XPRPDON?", buf): i = CLng(buf)
        'Xmath 2.Differential Execute ON/OFF
        err = QrySocket(U38_SockID, "XDIFFON?", buf): i = i + CLng(buf)
        'Xmath 4.Power Math Execute ON/OFF
        err = QrySocket(U38_SockID, "XMATHON?", buf): i = i + CLng(buf)
        If i = 0 Then
            err = MsgBox("Xmath Function OFF.", vbOKOnly)
            GoTo SocketClose
        End If
        
        err = PutSocket(U38_SockID, "VCFSEXTINIT")                  '     Initialize Specific Span external SG vector correction.
        err = QrySocket(U38_SockID, "VCFSEXTSTPSZ?", buf)           '     Get Specific Span external SG vector correction total count.
        If err < 0 Then
            err = MsgBox("VCFSEXTSTPSZ? query command error.", vbOKOnly)
            Exit Sub
        End If
        VCorr_TtlCnt = CLng(buf)                                    '     External SG vector correction total count.
        strVCorr_TtlCnt = CStr(VCorr_TtlCnt)
        
        err = QrySocket(U38_SockID, "VCFA?", buf)                   '     Start Freq.
        CentFreq = CDbl(Trim(buf))
        strFreq = CStr(CentFreq)
        err = PutSocket(SG_SockID, SG_SET_FRQ_CMD & strFreq & SG_SET_FRQ_UNT)
        Call Sleep(1000)
        Lbl_SG_Start_Freq.Caption = Trim(buf)
        err = QrySocket(U38_SockID, "VCFB?", buf)                   '     Stop  Freq.
        Lbl_SG_End_Freq.Caption = Trim(buf)
        err = QrySocket(U38_SockID, "VCFSTEP?", buf)                '     Step  Freq.
        Lbl_SG_Step_Freq.Caption = Trim(buf)
    
        Lbl_Count.Caption = "0/" & strVCorr_TtlCnt
        Lbl_Count.Refresh
        
        For i = 1 To VCorr_TtlCnt
            If VCorrAbort = True Then Exit For
            err = PutSocket(U38_SockID, "VCFSEXTIDX " & CStr(i))
            err = QrySocket(U38_SockID, "CF?", buf)
            CentFreq = CDbl(Trim(buf))
            strFreq = CStr(CentFreq)
            Lbl_SG_Current_Freq.Caption = strFreq
            err = PutSocket(SG_SockID, SG_SET_FRQ_CMD & strFreq & SG_SET_FRQ_UNT)
            Call Sleep(1000)
            err = PutSocket(U38_SockID, "VCFSEXTEXE")
            Lbl_Count.Caption = CStr(i) & " / " & strVCorr_TtlCnt
            DoEvents
        Next i

        If VCorrAbort = False Then
            err = PutSocket(U38_SockID, "VCFSEXTFINISH")            '     End Specific Span vector correction.
        Else
            err = PutSocket(U38_SockID, "VCFSEXTABORT")             '     Abort Specific Span vector correction.
            err = PutSocket(U38_SockID, "VCSIGSRC INT")             '     SigSrc INT
        End If
    Else                                                            '*** InBand ***
        err = PutSocket(U38_SockID, "VCINBEXTINIT")                 '     Initialize InBand external SG vector correction.
        err = QrySocket(U38_SockID, "VCINBEXTSTPSZ?", buf)          '     Get InBand external SG vector correction total count.
        If err < 0 Then
            err = MsgBox("VCINBEXTSTPSZ? query command error.", vbOKOnly)
            Exit Sub
        End If
        VCorr_TtlCnt = CLng(buf)                                    '     External SG vector correction total count.
        strVCorr_TtlCnt = CStr(VCorr_TtlCnt)
                
        Lbl_Count.Caption = "0/" & strVCorr_TtlCnt
        Lbl_Count.Refresh
        
        For i = 1 To VCorr_TtlCnt
            If VCorrAbort = True Then Exit For
            err = PutSocket(U38_SockID, "VCINBEXTIDX " & CStr(i))
            err = QrySocket(U38_SockID, "VCINBEXTFO?", buf)
            OfstFreq = CDbl(Trim(buf))
            err = QrySocket(U38_SockID, "CF?", buf)
            CentFreq = CDbl(buf)
            Lbl_SG_Current_Freq.Caption = strFreq
            strFreq = CStr(CentFreq + OfstFreq)
            err = PutSocket(SG_SockID, SG_SET_FRQ_CMD & strFreq & SG_SET_FRQ_UNT)
            Call Sleep(1000)
            err = PutSocket(U38_SockID, "VCINBEXTEXE")
            Lbl_Count.Caption = CStr(i) & " / " & strVCorr_TtlCnt
            DoEvents
        Next i

        If VCorrAbort = False Then
            err = PutSocket(U38_SockID, "VCINBEXTFINISH")           '     End InBand vector correction.
        Else
            err = PutSocket(U38_SockID, "VCINBEXTABORT")            '     Abort InBand vector correction.
            err = PutSocket(U38_SockID, "VCSIGSRC INT")             '     SigSrc INT
        End If
    End If
    
SocketClose:
    Call CloseConnect(U38_SockID)
    Call CloseConnect(SG_SockID)
    
    Call CloseWinsock
    
End Sub

'*********************************************
'* U3800 External SG Vector Correction Abort *
'*********************************************
Private Sub CmdVCorrAbort_Click()
    VCorrAbort = True
End Sub

'*************
'* Form load *
'*************
Private Sub Form_Load()

    VCorrAbort = False
    
    str_U38_TcpipAddress = Trim(ReadIniFile_U38_TCPIP_Adrs())
    Txt_U38_IP_Address.Text = str_U38_TcpipAddress
    Call WriteIniFile_U38_TCPIP_Adrs(Txt_U38_IP_Address.Text)

    str_SG_TcpipAddress = Trim(ReadIniFile_SG_TCPIP_Adrs())
    Txt_SG_IP_Address.Text = str_SG_TcpipAddress
    Call WriteIniFile_SG_TCPIP_Adrs(Txt_SG_IP_Address.Text)
    
    U38_PortNo = CLng(ReadIniFile_U38_PortNo())
    Call WriteIniFile_U38_PortNo(CStr(U38_PortNo))
    
    SG_PortNo = CLng(ReadIniFile_SG_PortNo())
    Call WriteIniFile_SG_PortNo(CStr(SG_PortNo))
    
    SG_OutputLevel = CSng(Trim(ReadIniFile_SG_OUT_LVL()))
    Txt_SG_Out_Level.Text = CStr(SG_OutputLevel)
    Call WriteIniFile_SG_OUT_LVL(Txt_SG_Out_Level.Text)
    
    If "Specific Span" = Trim(ReadIniFile_U38_VCorr_Type()) Then
        Opt_VCorr_Type1.Value = True
        Opt_VCorr_Type2.Value = False
        Call WriteIniFile_U38_VCorr_Type(Opt_VCorr_Type1.Caption)
    Else
        Opt_VCorr_Type1.Value = False
        Opt_VCorr_Type2.Value = True
        Call WriteIniFile_U38_VCorr_Type(Opt_VCorr_Type2.Caption)
    End If

    SG_OUTPUT__CMD = Trim(ReadIniFile_SG_OUT_STS_Cmd())
    Call WriteIniFile_SG_OUT_STS_Cmd(SG_OUTPUT__CMD)
    
    SG_OUT_ON__CMD = Trim(ReadIniFile_SG_OUT_ON_Para())
    Call WriteIniFile_SG_OUT_ON_Para(SG_OUT_ON__CMD)
    SG_OUT_ON__CMD = SG_OUTPUT__CMD & " " & SG_OUT_ON__CMD
    
    SG_OUT_OFF_CMD = Trim(ReadIniFile_SG_OUT_OFF_Para())
    Call WriteIniFile_SG_OUT_OFF_Para(SG_OUT_OFF_CMD)
    SG_OUT_OFF_CMD = SG_OUTPUT__CMD & " " & SG_OUT_OFF_CMD
    
    SG_OUT_LVL_CMD = Trim(ReadIniFile_SG_OUT_LVL_Cmd())
    Call WriteIniFile_SG_OUT_LVL_Cmd(SG_OUT_LVL_CMD)
    SG_OUT_LVL_CMD = SG_OUT_LVL_CMD & " "
    
    SG_OUT_LVL_UNT = Trim(ReadIniFile_SG_OUT_LVL_Unit())
    Call WriteIniFile_SG_OUT_LVL_Unit(SG_OUT_LVL_UNT)
    
    SG_SET_FRQ_CMD = Trim(ReadIniFile_SG_Freq_Cmd())
    Call WriteIniFile_SG_Freq_Cmd(SG_SET_FRQ_CMD)
    SG_SET_FRQ_CMD = SG_SET_FRQ_CMD & " "
    
    SG_SET_FRQ_UNT = Trim(ReadIniFile_SG_Freq_Unit())
    Call WriteIniFile_SG_Freq_Unit(SG_SET_FRQ_UNT)
    
End Sub
